/*  Waves.java Applet - displays wave interefence patterns
 *
 *   Copyright (C) 2001  Georg Wilckens <durandal@nfinity.de>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA
 */

import java.awt.*;
import java.awt.image.*;

/* Please note that 99.99% of this code was written in 1998 (using
 * Windows Notepad *urgh*), so I might have no clue, what this is
 * about, but go ahead and ask me if you have any questions -- Georg
 * Wilckens <durandal@nfinity.de> */

public class Waves extends java.applet.Applet implements Runnable {

Scrollbar waveLength;
int waveLengthValue;
TextField waveLengthText;
Point[] oscillator = new Point[5];
boolean edit = true;
boolean calculating = false;
boolean schema = false;
boolean color = false;
int selectedOscillator = 1;
long doneBy = 0l;
int frame = 0;
int progBit = 0;

DrawArea drawArea = new DrawArea(this);
Button switcher = new Button("Show");
Thread painter;
int timeout;

public String getAppletInfo() {
	return
		  "Author: Georg Wilckens\n"
		+ "Title:  Waves v5.0\n"
		+ "Copyright 1998, 2001";
}

public String[][] getParameterInfo() {
	String[][] description = {
		{"Timeout", "int", "Time in ms between redraws"}
	};
	return description;
}

public void init() {
	timeout = Integer.parseInt(getParameter("Timeout"));

	setLayout(new FlowLayout());
	setBackground(Color.white);

	add(GUI());
}

public void start() {
}

public void stop() {
	if(painter != null) {
		painter.stop();
		painter = null;
	}
}

public void run() {

	Image[] img = new Image[waveLengthValue];

	calculating = true;
	long dummy = 0l;
	doneBy = 0l;

	for(frame = 0; frame <= img.length - 1; frame++) {
		drawArea.repaint();
		if(frame == 0)
			dummy = System.currentTimeMillis();
		img[frame] = schema ? createSchema(waveLengthValue, oscillator, frame) : createPicture(waveLengthValue, oscillator, frame);
		if(frame == 0)
			doneBy = System.currentTimeMillis() + (img.length - 2) * (System.currentTimeMillis() - dummy);
	}
	calculating = false;

	Graphics g = drawArea.getGraphics();

	while(true) {
		for(int i = 0; i <= img.length - 1; i++) {
			g.drawImage(img[i], 0, 0, this);
			try {
				Thread.sleep(timeout);
			} catch(InterruptedException ignored) {}
		}
	}
}

public Panel GUI() {	
	Panel main = new Panel();

	main.setLayout(new BorderLayout());
	main.setBackground(Color.white);

	drawArea.resize(300,300);
	
	Panel cont = new Panel();
	cont.setLayout(new BorderLayout());
	cont.setBackground(Color.white);

	Panel element = new Panel();
	element.setLayout(new FlowLayout());
	element.setBackground(Color.white);

	waveLength = new Scrollbar(Scrollbar.HORIZONTAL, 15, 4, 2, 30);
	waveLengthText = new TextField("15", 2);
	waveLengthValue = 15;
	
	element.add(new Label("Wellenlnge"));
	element.add(waveLength);
	element.add(waveLengthText);
	element.add(switcher);

	cont.add("North", element);

	Panel small = new Panel();
	small.setLayout(new FlowLayout());
	small.add(new Checkbox("Schematische Darstellung"));
	small.add(new Checkbox("Color"));
	cont.add("South", small);

	Panel selector = new Panel();
	selector.setLayout(new FlowLayout());
	selector.setBackground(Color.white);

	selector.add(new Label("Oszillator"));

	CheckboxGroup select = new CheckboxGroup();
	selector.add(new Checkbox("1", select, true));
	selector.add(new Checkbox("2", select, false));
	selector.add(new Checkbox("3", select, false));
	selector.add(new Checkbox("4", select, false));
	selector.add(new Checkbox("5", select, false));

	main.add("North", selector);
	main.add("Center", drawArea);
	main.add("South", cont);

	return main;
}


Image createPicture(int wavelength, Point[] point, int phase) {

	int[] temp = new int[300 * 300];

	for(int i = 0; i <= 299; i++) {
		if((double) i / 30 == Math.floor((double) i / 30)) {
			progBit = i / 30;
			drawArea.repaint();
		}

		for(int j = 0; j <= 299; j++) {
			int y = 0;
			if(color && point[3] == null && point[4] == null) {
				for (int k = 0; k <= point.length - 3; k++) {
					if(point[k] != null)
						y += (1 << (8 * k)) * (int) Math.floor((double) (55 * Math.sin((double) (2 * Math.PI * ((Math.sqrt(Math.pow((double) point[k].y-i, 2d) + Math.pow((double) point[k].x-j, 2d)) - phase) / wavelength)))) + 55);
				}
				temp[300 * i + j] = 0xff000000 + y;
			} else {

				for (int k = 0; k <= point.length - 1; k++) {
					if(point[k] != null)
						y += 25 * Math.sin((double) (2 * Math.PI * ((Math.sqrt(Math.pow((double) point[k].y-i, 2d) + Math.pow((double) point[k].x-j, 2d)) - phase) / wavelength)));
				}
				temp[300 * i + j] = 0xff000000 + 0x010101 * (int) Math.floor((double) y + 127);
			}
		}
	}

	Image tmp = createImage(new MemoryImageSource(300, 300, temp, 0, 300));
	return tmp;
}

Image createSchema(int wavelength, Point[] point, int phase) {

	Image temp = createImage(300,300);
	Graphics g = temp.getGraphics();

	g.setColor(Color.black);

	for(int i = 0; i <= point.length - 1; i++)
		if(point[i] != null)
			for(int j = 0; j <= 425 / wavelength; j++)
				g.drawArc(point[i].x - (wavelength * j + phase), point[i].y - (wavelength * j + phase), (wavelength * 2 * j + 2 * phase), (wavelength * 2 * j + 2 * phase), 0, 360);

	return temp;
}

public boolean handleEvent(Event e) {
	super.handleEvent(e);

	if(e.target instanceof Scrollbar) {
		if(waveLength.getValue() != waveLengthValue) {

			if(painter != null) {
				painter.stop();
				painter = null;
				calculating = false;
			}

			waveLengthValue = waveLength.getValue();
			waveLengthText.setText(Integer.toString(waveLengthValue));

			if(!edit) {
				painter = new Thread(this);
				painter.start();
			}
		}
	}
	return false;
}

public boolean action(Event e, Object arg) {
	if(e.target instanceof Checkbox && (((Checkbox) e.target).getLabel() != "Schematische Darstellung") && (((Checkbox) e.target).getLabel() != "Color")) {
		selectedOscillator = Integer.parseInt(((Checkbox) e.target).getLabel());
		if(edit)
			oscillator[Integer.parseInt(((Checkbox) e.target).getLabel()) - 1] = null;
		drawArea.repaint();

	} else if(e.target instanceof Checkbox && (((Checkbox) e.target).getLabel() == "Schematische Darstellung")) {
		schema = ((Checkbox) e.target).getState();
		if(painter != null) {
			painter.stop();
			painter = new Thread(this);
			painter.start();
		}
	} else if(e.target instanceof Checkbox && (((Checkbox) e.target).getLabel() == "Color")) {
		color = ((Checkbox) e.target).getState();
		if(painter != null) {
			painter.stop();
			painter = new Thread(this);
			painter.start();
		}
	} else if (e.target instanceof Button) {
		edit = !edit;
		if(edit) {
			switcher.setLabel("Show");
			if(painter != null) {
				painter.stop();
				painter = null;
				calculating = false;
			}
			drawArea.repaint();
		} else {
			switcher.setLabel("Edit");
			if(painter == null) {
				painter = new Thread(this);
				painter.start();
			}
		}
		validate();
	}

	return true;
}

public void paint(Graphics g) {
	if(painter == null && !edit) {
		painter = new Thread(this);
		painter.start();
	}
}}

//-----------------------------------------------------------------------------------------------
class DrawArea extends Canvas {

Waves waves;
boolean running = true;

public DrawArea(Waves waves) {
	this.waves = waves;
}

public boolean mouseDown(Event e, int x, int y) {
	if(waves.edit) {
		waves.oscillator[waves.selectedOscillator - 1] = new Point(x, y);
		repaint();
	} else if(waves.painter.isAlive()) {
		if(running && !waves.calculating)
			waves.painter.suspend();
		else
			waves.painter.resume();
		running = !running;
	}
	return true;
}

public boolean mouseDrag(Event e, int x, int y) {
	if(waves.edit) {
		waves.oscillator[waves.selectedOscillator - 1] = new Point(x, y);
		repaint();
	}
	return true;
}

public void paint(Graphics g) {
	if(waves.edit) {

		g.clearRect(g.getClipRect().x, g.getClipRect().y, g.getClipRect().width, g.getClipRect().height);
		g.setFont(new Font("Arial", Font.PLAIN, 12));

		for(int i = 0; i <= waves.oscillator.length - 1; i++)
			if(waves.oscillator[i] != null) {
				g.setColor(Color.red);
				g.drawLine(waves.oscillator[i].x, 0, waves.oscillator[i].x, 300);
				g.drawLine(0, waves.oscillator[i].y, 300, waves.oscillator[i].y);
				g.setColor(Color.black);
				g.drawString(Integer.toString(i + 1), waves.oscillator[i].x + 1, waves.oscillator[i].y - 1);
			}
	}

	else if(waves.calculating) {
		g.clearRect(g.getClipRect().x, g.getClipRect().y, g.getClipRect().width, g.getClipRect().height);
		g.setFont(new Font("Arial", Font.PLAIN, 12));

		g.setColor(Color.black);
		g.drawString("calculating animation frames", 50, 100);
		if(waves.doneBy != 0)
			g.drawString("approximated waiting time: " + ((waves.doneBy - System.currentTimeMillis()) / 60000) + " minutes.", 50, 120);
			g.drawString("frame in process: " + (waves.frame + 1) + " of " + waves.waveLengthValue, 50, 140);
			int percent = (int) (100 * (10 * (double) waves.frame + waves.progBit) / (double) (10 * waves.waveLengthValue));
			g.drawRect(100, 160, 101, 21);
			g.fillRect(101, 161, percent, 20);
			g.drawString(Integer.toString(percent) + "%", 211, 177); 
	}
}}
